<?php
/**
 * Create Ticket
 *
 * @package     AutomatorWP\Integrations\Fluent_Support\Actions\Create_Ticket
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Fluent_Support_Add_Contact extends AutomatorWP_Integration_Action {

    public $integration = 'fluent_support';
    public $action = 'fluent_support_create_ticket';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Create new ticket', 'automatorwp-pro' ),
            'select_option'     => __( 'Create new <strong>ticket</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Ticket. */
            'edit_label'        => sprintf( __( 'Create new %1$s', 'automatorwp-pro' ), '{ticket}' ),
            /* translators: %1$s: Ticket. */
            'log_label'         => sprintf( __( 'Create new %1$s', 'automatorwp-pro' ), '{ticket}' ),
            'options'           => array(
                'ticket' => array(
                    'default' => __( 'ticket', 'automatorwp-pro' ),
                    'fields' => array(
                        'customer' => array(
                            'name' => __( 'Customer email:', 'automatorwp-pro' ),
                            'desc' => __( 'The customer email. By default, email of user who completes this automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'first_name' => array(
                            'name' => __( 'Customer first name:', 'automatorwp-pro' ),
                            'desc' => __( 'The customer first name.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'last_name' => array(
                            'name' => __( 'Customer last name:', 'automatorwp-pro' ),
                            'desc' => __( 'The customer last name.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'subject' => array(
                            'name' => __( 'Subject:', 'automatorwp-pro' ),
                            'desc' => __( 'The tickets\'s subject.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'details' => array(
                            'name' => __( 'Details:', 'automatorwp-pro' ),
                            'desc' => __( 'The ticket\'s details.', 'automatorwp-pro' ),
                            'type' => 'wysiwyg',
                            'default' => ''
                        ),
                        'product' => automatorwp_utilities_ajax_selector_field( array(
                            'field'             => 'product',
                            'option_default'    => __( 'Select a product', 'automatorwp-fluentcrm' ),
                            'name'              => __( 'Product:', 'automatorwp-fluentcrm' ),
                            'action_cb'         => 'automatorwp_fluent_support_get_products',
                            'options_cb'        => 'automatorwp_fluent_support_options_cb_product',
                            'default'           => ''
                        ) ),
                        'priority' => array(
                            'name' => __( 'Priority:', 'automatorwp-pro' ),
                            'desc' => __( 'The ticket\'s priority.', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'normal'    => __('Normal', 'automatorwp-pro'),
                                'medium'    => __('Medium', 'automatorwp-pro'),
                                'critical'  => __('Critical', 'automatorwp-pro'),    
                            ),
                            'default' => 'normal'
                        ),
                    )
                )
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        if ( empty( $action_options['customer'] ) ) {

            $user_data = get_user_by( 'id', $user_id );
            $user_email = $user_data->user_email;

        } else {

            $user_email = $action_options['customer'];

        }
        
        $first_name = $action_options['first_name'];
        $last_name = $action_options['last_name'];

        $ticket_data = array(
            'customer_id'       => 0,
            'title'             => $action_options['subject'],
            'content'           => $action_options['details'],
            'product_id'        => $action_options['product'],
            'client_priority'   => $action_options['priority'],
        );

        $this->result = '';
        
        $customer = \FluentSupport\App\Models\Customer::where( 'email', $user_email )->first();
        
        if ( $customer && $customer instanceof \FluentSupport\App\Models\Customer ) {

            // Customer or WordPress user
            $ticket_data['customer_id'] = $customer->id;

        } else {

            $new_customer = array(
                'first_name'    => $first_name,
                'last_name'     => $last_name,
                'email'         => $user_email,
            );

            // Create a new customer and get the ID.
            $customer = \FluentSupport\App\Models\Customer::maybeCreateCustomer( $new_customer );

            if ( $customer && $customer instanceof \FluentSupport\App\Models\Customer ) {

                $ticket_data['customer_id'] = $customer->id;

            }

        }

        $created_ticket = \FluentSupport\App\Models\Ticket::create( $ticket_data );

        $this->result = __( 'Ticket created successfully', 'automatorwp-pro' );

    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }

}

new AutomatorWP_Fluent_Support_Add_Contact();